<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Deposit;
use App\Models\User;

class UserDepositController extends Controller
{
    public function create()
    {
        return view('components.admin.user-deposit', ['data' => Deposit::orderBy('created_at', 'desc')->paginate(10)]);
    }

   public function patch($id, $status)
{
    $deposit = Deposit::findOrFail($id); // Memastikan deposit ditemukan

    $user = User::where('username', $deposit->username)->firstOrFail(); // Memastikan user ditemukan
    $user->refresh(); // Memuat ulang data user dari basis data

    // Perbarui saldo user
    $user->increment('balance', $deposit->jumlah);

    // Perbarui status deposit
    $deposit->update([
        'status' => $status
    ]);

    return back()->with('success', 'Berhasil konfirmasi deposit');
}

}
